' Utility to reset the 'solved' value for ALL puzzles to 0.
' Rev 1.0.0 William M Leue 18-May-2024

option default integer
option base 1

const NSIZES = 3
const MAXHPR = 19

dim sizenames$(NSIZES) = ("SMALL", "MEDIUM", "LARGE")
dim pnums(100)
dim board(2, 2)
dim nrows(NSIZES)
dim nhpr(NSIZES, MAXHPR)

' Main Program
open "debug.txt" for output as #1
ReadHexData
tn = 0
for i = 1 to NSIZES
  InitBoard i
  FindAllPuzzles i, pnums(), n
  SortPuzzles pnums(), n
  for j = 1 to n
    puzz_num = pnums(j)
    LoadPartition i, puzz_num, npart
    SavePartition i, puzz_num, npart
    inc tn
  next j
next i
print "Did 'solved' reset for ";tn;" puzzles."
end

' Read the Hex board data
sub ReadHexData
  local s, i, j, n
  for s = 1 to NSIZES
    read nrows(s)
    n = 0
    for i = 1 to nrows(s)
      read nhpr(s, i)
      inc n, nhpr(s, i)
    next i
  next s
end sub

' Initialize the board
sub InitBoard size
  erase board()
  dim board(nrows(size), MAXHPR)
end sub
  
' Find all puzzles for the specified puzzle size
sub FindAllPuzzles size, pnums(), count
  local p$, f$, n, r$, fl, maxn
  n = 0 : count = 0
  p$ = "./PUZZLES/" + sizenames$(size) + "/*"
  f$ = DIR$(p$, FILE)
  do while f$ <> ""
    fl = len(f$)
    r$ = LEFT$(f$, fl-4)
    r$ = MID$(r$, 5)
    n = val(r$)
    inc count
    pnums(count) = n
    f$ = DIR$()
  loop
end sub

' Sort the puzzles into increasing order
sub SortPuzzles pnums(), n
  sort pnums(),,,, n
end sub

' Load Partition from disk
sub LoadPartition size, puzz_num, npart
  local p$, buf$, ps, row, h, solved
  p$ = "./PUZZLES/" + UCASE$(sizenames$(size)) + "/part" + str$(puzz_num) + ".prt"
  on error skip 1
  open p$ for input as #2
  if mm.errno <> 0 then
    cls
    print "Error opening file '";p$;"' for input: ";mm.errmsg$
    end
  end if
  line input #2, buf$
  ps = val(buf$)
  if ps <> size then
    cls
    print "Error : partition grid size does not match selected size"
    end
  end if
  line input #2, buf$
  npart = val(buf$)
  line input #2, buf$
  solved = val(buf$)
  for row = 1 to nrows(size)
    line input #2, buf$
    for h = 1 to nhpr(size, row)
      board(row, h) = val(field$(buf$, h, ","))
    next h
  next row
  close #2
end sub

' Save the Partition to disk
sub SavePartition size, puzz_num, npart
  local n, path$, i, row, h, solved
  path$ = "./PUZZLES/" + sizenames$(size) + "/part" + str$(puzz_num) + ".prt"
  on error skip 1
  open path$ for output as #2
  if mm.errno <> 0 then
    cls
    print "Error opening '";path$;" for output: ";mm.errmsg$
    end
  end if
  print #2, str$(size)
  print #2, str$(npart)
  solved = 0
  print #2, str$(solved)
  for row = 1 to nrows(size)
    n = nhpr(size, row)
    for h = 1 to n
      print #2, str$(board(row, h)) + ",";
    next h
    print #2, ""
  next row
  close #2
end sub

' Hex data: each row begins with number of rows in board,
' followed by number of hexes per row.
data  7, 2, 1, 2, 3, 2, 1, 2
data 13, 3, 2, 3, 4, 3, 4, 5, 4, 3, 4, 3, 2, 3
data 19, 4, 3, 4, 5, 4, 5, 6, 5, 6, 7, 6, 5, 6, 5, 4, 5, 4, 3, 4

